go
IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_TELE_ORC_ETAPA_ULTIMA')
begin
	DROP TRIGGER [dbo].[TRG_TELE_ORC_ETAPA_ULTIMA]
end
go

CREATE TRIGGER [dbo].[TRG_TELE_ORC_ETAPA_ULTIMA] ON [dbo].[TELE_ORC_ETAPA] FOR INSERT AS
		BEGIN TRY
		--GRAVANDO ULTIMA ETAPA DO ORCAMENTO
		  BEGIN
		  
		  --Ajustado conforme FARMAGOI-29632
			/*IF NOT EXISTS (
				SELECT A.CD_ORC 
				  FROM TELE_ORC A INNER JOIN INSERTED I ON
				       I.CD_ORC = A.CD_ORC AND 
					   A.ENTREGA_BALCAO = 1 AND
					   I.CD_ETAPAS = 2 AND
					   I.CD_TIPO = 1
				
			)*/
			BEGIN

				  --DELETE A ULTIMA ETAPA ANTERIOR
				--PARA ACRESCENTAR A NOVA ULTIMA ENTRADA
				DELETE 
					U
				FROM TELE_ORC_ETAPA_ULTIMA U INNER JOIN INSERTED I ON
					 U.CD_ORC = I.CD_ORC
		
				DELETE 
					U
				FROM TELE_ORC_ETAPA_ULTIMA_FINAL U INNER JOIN INSERTED I ON
					 U.CD_ORC = I.CD_ORC
				--FIM
		
				INSERT INTO TELE_ORC_ETAPA_ULTIMA
					SELECT		
						CD_ORC, 
						CD_ORC_ETAPA,
						GETDATE()
					FROM          
						INSERTED
					WHERE
						CD_ETAPAS NOT IN (6,10,5)
		
				INSERT INTO TELE_ORC_ETAPA_ULTIMA_FINAL
					SELECT		
						CD_ORC, 
						CD_ORC_ETAPA,
						GETDATE()
					FROM          
						INSERTED

				UPDATE B
					SET
						B.CD_ORC_ETAPA = A.CD_ORC_ETAPA,
						B.CD_ETAPAS    = A.CD_ETAPAS,
						B.CD_TIPO      = A.CD_TIPO
				FROM          
						INSERTED A INNER JOIN
						TELE_ORC B ON A.CD_ORC = B.CD_ORC
				WHERE A.CD_ORC = B.CD_ORC
			END
		  END
		END TRY
		BEGIN CATCH
			IF @@NESTLEVEL > 0 
			declare @erro varchar (500) = ERROR_MESSAGE();
			INSERT INTO ADM_ERRO (NUMERO, SEVERIDADE, ESTADO, ROTINA, LINHA, MENSAGEM, DTERRO)
				SELECT
					ERROR_NUMBER() AS NUMERO,
					ERROR_SEVERITY() AS SEVERIDADE,
					ERROR_STATE() AS ESTADO,
					ERROR_PROCEDURE() AS ROTINA,
					ERROR_LINE() AS LINHA,
					ERROR_MESSAGE() AS MENSAGEM,
					GETDATE() AS DTERRO;
					raiserror (@erro,16, 1)
		END CATCH


GO

